<?php

	include_once( PLOG_CLASS_PATH."class/security/pipelinefilter.class.php" );
    include_once( PLOG_CLASS_PATH."class/net/client.class.php" );
    include_once( PLOG_CLASS_PATH."class/misc/glob.class.php" );

    // custom error code that will be returned to the pipeline whenever an
    // error is found... Be careful so as to not to have two different modules
    // use the same code!!
    define( "HOTLINK_PREVENTION_MATCH_FOUND", 650 );

	class HotlinkPreventionFilter extends PipelineFilter 
	{
    	function HotlinkPreventionFilter( $pipelineRequest )
        {
        	$this->PipelineFilter( $pipelineRequest );
        }

        function filter()
        {
        	// get some info
            $blogInfo = $this->_pipelineRequest->getBlogInfo();
            $request  = $this->_pipelineRequest->getHttpRequest();
            
			// load global configuration settings
			$config =& Config::getConfig();
			$globalPluginEnabled = $config->getValue( "plugin_globalhotlinkprevention_enabled" );
			$globalFileExtensions = $config->getValue( "plugin_globalhotlinkprevention_fileextensions" );
			$globalBlankRefererEnabled = $config->getValue( "plugin_globalhotlinkprevention_blankrefererenabled" );
			$globalAllowReferers = $config->getValue( "plugin_globalhotlinkprevention_allowreferers" );

			// load blog configuration settings
			$blogSettings = $blogInfo->getSettings();
			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_enabled" ) ) {
				$pluginEnabled = $blogSettings->getValue( "plugin_hotlinkprevention_enabled" );
			} else {
				$pluginEnabled = $globalPluginEnabled;
			}

			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_fileextensions" ) ) {
				$fileExtensions = $blogSettings->getValue( "plugin_hotlinkprevention_fileextensions" );
			} else {
				$fileExtensions = $globalFileExtensions;
			}

			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_blankrefererenabled" ) ) {
				$blankRefererEnabled = $blogSettings->getValue( "plugin_hotlinkprevention_blankrefererenabled" );
			} else {
				$blankRefererEnabled = $globalBlankRefererEnabled;
			}			
			
			if ( $blogSettings->keyExists( "plugin_hotlinkprevention_allowreferers" ) ) {
				$allowReferers = $blogSettings->getValue( "plugin_hotlinkprevention_allowreferers" );
			} else {
				$allowReferers = $globalAllowReferers;
			}
			
        	// check if this section has been enabled or disabled
            if( !$pluginEnabled) {
            	// if not, nothing to do here...
            	$result = new PipelineResult();
                return $result;
            }

            // we only have to filter the contents if the user is posting a comment
            // so there's no point in doing anything else if that's not the case
            if( $request->getValue( "op" ) != "ResourceServer" ) {
            	$result = new PipelineResult();
                return $result;
            }

            // text and topic of the comment
			$referer = $_SERVER['HTTP_REFERER'];
			$fileName = $request->getValue( "resource" );
			$allowRefererFound = false;
			
		    if ($referer == "" && !$blankRefererEnabled) {
				$result = new PipelineResult( false, HOTLINK_PREVENTION_MATCH_FOUND, "error_hotlinkprevention_referer_banned" );
		        return $result;
			} elseif ($referer == "" && $blankRefererEnabled) {
				$allowRefererFound = true;
			} else {
			    foreach(explode( "\r\n", $allowReferers ) as $allowReferer ) {
			       	trim($allowReferer);
			       	if( $allowReferer != "" && $allowReferer != "\r\n" && $allowReferer != "\r" && $allowReferer != "\n" ) {
			       		if( strstr( $referer, $allowReferer )) {
							$allowRefererFound = true;
							break;
		                }
			    	}
			    }
			}

			if ($allowRefererFound) {
			    $result = new PipelineResult();
                return $result;
			} else {
			    foreach(explode( " ", $fileExtensions ) as $fileExtension ) {
			       	trim($fileExtension);
			       	if( $fileExtension != "" && $fileExtension != " " ) {
	            		if( Glob::myFnmatch( $fileExtension, $fileName )) {
							$result = new PipelineResult( false, HOTLINK_PREVENTION_MATCH_FOUND, "error_hotlinkprevention_referer_banned" );
					        return $result;
		            	}	       		
			       	} 
			    }				
			    $result = new PipelineResult();
                return $result;
		    }
        }
    }
?>