<?php
	
	include_once( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the feed reader plugin
	 */
	class PluginGlobalHotlinkPreventionConfigView extends AdminPluginTemplatedView
	{

		function PluginGlobalHotlinkPreventionConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "hotlinkprevention", "globalhotlinkprevention" );
		}
		
		function render()
		{
			// load some configuration settings
			$config =& Config::getConfig();
			$pluginEnabled = $config->getValue( "plugin_globalhotlinkprevention_enabled" );
			$allowBlogOwnerOverride = $config->getValue( "plugin_globalhotlinkprevention_allowblogowneroverride" );
			$fileExtensions = $config->getValue( "plugin_globalhotlinkprevention_fileextensions" );
			if ($fileExtensions == "") $fileExtensions = "*.*";
			$blankRefererEnabled = $config->getValue( "plugin_globalhotlinkprevention_blankrefererenabled" );
			$allowReferers = $config->getValue( "plugin_globalhotlinkprevention_allowreferers" );
			if ($allowReferers == "") {
				$rg =& RequestGenerator::getRequestGenerator( $blogInfo );
				$allowReferers = $rg->getBaseUrl();
			}
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "allowBlogOwnerOverride", $allowBlogOwnerOverride );
			$this->setValue( "fileExtensions", $fileExtensions );
			$this->setValue( "blankRefererEnabled", $blankRefererEnabled );	
			$this->setValue( "allowReferers", $allowReferers );
			
			parent::render();
		}
	}
?>