<?php

    include_once( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    include_once( PLOG_CLASS_PATH."class/plugin/pluginmanager.class.php" );
    include_once( PLOG_CLASS_PATH."plugins/hotlinkprevention/class/security/hotlinkpreventionfilter.class.php" );
    
    /**
     * Plugin that offers features to return a recent article comments from the current blog
     */
    class PluginHotlinkPrevention extends PluginBase
    {
        var $pluginEnabled;
        var $allowBlogOwnerOverride;
        
        function PluginHotlinkPrevention()
        {
            $this->PluginBase();
  
            $this->id = "hotlinkprevention";
            $this->author = "Mark Wu";
            $this->desc = "This plugin offers the hotlink prevention to resource.";
  
            $config =& Config::getConfig();
            $this->pluginEnabled = $config->getValue( "plugin_globalhotlinkprevention_enabled" );
            $this->allowBlogOwnerOverride = $config->getValue( "plugin_globalhotlinkprevention_allowblogowneroverride" );
            
            $this->locales = Array( "en_UK" , "zh_TW" );
            
            $this->init();
        }

		function init()
		{
            // we only need to register a filter
            $this->registerFilter( "HotlinkPreventionFilter" );

            $this->registerAdminAction( "globalHotlinkPrevention", "PluginGlobalHotlinkPreventionConfigAction" );
			$this->registerAdminAction( "updateGlobalHotlinkPreventionConfig", "PluginGlobalHotlinkPreventionUpdateConfigAction" );
            $this->registerAdminAction( "hotlinkprevention", "PluginHotlinkPreventionConfigAction" );
			$this->registerAdminAction( "updateHotlinkPreventionConfig", "PluginHotlinkPreventionUpdateConfigAction" );
			
			$this->addMenuEntry( "/menu/adminSettings/GlobalSettings", "globalHotlinkPrevention", "?op=globalHotlinkPrevention", "" );
			
			if($this->pluginEnabled && $this->allowBlogOwnerOverride) {
				$menu =& Menu::getMenu();
				if( !$menu->entryExists( "/menu/controlCenter/manageSecurityPlugins" ))
					$this->addMenuEntry( "/menu/controlCenter", "manageSecurityPlugins", "", "", true, false );
	            $this->addMenuEntry( "/menu/controlCenter/manageSecurityPlugins", "HotlinkPrevention", "?op=hotlinkprevention", "" );
	        }
		}
    }
?>