<?php

	include_once( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	include_once( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	include_once( PLOG_CLASS_PATH."plugins/hotlinkprevention/class/view/pluginglobalhotlinkpreventionconfigview.class.php" );	
	include_once( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
		
	/**
	 * updates the plugin configuration
	 */
	class PluginGlobalHotlinkPreventionUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
		var $_allowBlogOwnerOverride;
		var $_fileExtensions;
		var $_blankRefererEnabled;
		var $_allowReferers;
		
		function PluginGlobalHotlinkPreventionUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
			
        	// for data validation purposes, fileExtensions can not be empty
        	$this->registerFieldValidator( "fileExtensions", new StringValidator());
        	$view = new PluginGlobalHotlinkPreventionConfigView( $this->_blogInfo );
        	$view->setErrorMessage( $this->_locale->tr("error_hotlinkprevention_fileextensions"));
        	$this->setValidationErrorView( $view );
        	
        	// these fields do not need to be validated but should be there when we show the view once again
        	$this->registerField( "pluginEnabled" );
        	$this->registerField( "allowBlogOwnerOverride" );
        	$this->registerField( "blankRefererEnabled" );
        	$this->registerField( "allowReferers" );        	
		}
		
		function perform()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );
            $this->_allowBlogOwnerOverride = $this->_request->getValue( "allowBlogOwnerOverride" );
            $this->_allowBlogOwnerOverride = ($this->_allowBlogOwnerOverride != "" );            
            $this->_blankRefererEnabled = $this->_request->getValue( "blankRefererEnabled" );
            $this->_blankRefererEnabled = ($this->_blankRefererEnabled != "" );	
            $this->_fileExtensions = $this->_request->getValue( "fileExtensions" );
            $this->_allowReferers = $this->_request->getValue( "allowReferers" );
            
            // update the plugin configurations to config
			$config =& Config::getConfig();
            $config->setValue( "plugin_globalhotlinkprevention_enabled", $this->_pluginEnabled );
            $config->setValue( "plugin_globalhotlinkprevention_allowblogowneroverride", $this->_allowBlogOwnerOverride );
            $config->setValue( "plugin_globalhotlinkprevention_fileextensions", $this->_fileExtensions );
            $config->setValue( "plugin_globalhotlinkprevention_blankrefererenabled", $this->_blankRefererEnabled );
            $config->setValue( "plugin_globalhotlinkprevention_allowreferers", $this->_allowReferers );
		
			// save the config settings
            if( !$config->save() ) {
                $this->_view = new PluginGlobalHotlinkPreventionConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }

			// if everything went ok...
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();

			$this->_view = new PluginGlobalHotlinkPreventionConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("hotlinkprevention_settings_saved_ok"));
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());				
            
            return true;		
		}
	}
?>